SCR=$78000
SCR1=$70000
WIDTH=16
HEIGHT=16
ADDER=(WIDTH*256)*4

 BRA START
BUFF:
 DS.B 3000,0

START:
 CLR.L -(SP)     ;SV MODE
 MOVE.W #$20,-(SP)
 TRAP #1
 ADDQ.L #6,SP
 MOVE.L D0,SPAR+4

 PEA MOUSE
 MOVE.W #0,-(SP)
 MOVE.W #25,-(SP)
 TRAP #14
 ADDQ.L #8,SP

 CLR.W -(SP)     ;SETSCR
 PEA SCR
 PEA SCR
 MOVE.W #5,-(SP)
 TRAP #14
 ADD.L #12,SP

 AND.B #%11111110,$484
 LEA $FF8240,A0
 LEA OPAL,A1
 MOVEQ #7,D0
 BSR COPY
 LEA PAL,A0
 LEA $FF8240,A1
 MOVEQ #7,D0
 BSR COPY

 BSR CREATELAB

 LEA SCR1,A0
 MOVE.W #15999,D0
CLS:
 CLR.L (A0)+
 DBRA D0,CLS

 MOVE.W #$2700,SR
 MOVE.L $70,OVBL
 MOVE.L #VBL,$70
 MOVE.W #$2300,SR

DEADLOP:
 CMP.B #$66,$FFFC02
 BNE DEADLOP

EXIT:
 MOVE.W #$2700,SR
 MOVE.L OVBL,$70
 MOVE.W #$2300,SR

 MOVE.W #1,-(SP)
 PEA SCR
 PEA SCR
 MOVE.W #5,-(SP)
 TRAP #14
 ADD.L #12,SP

 LEA OPAL,A0
 LEA $FF8240,A1
 MOVEQ #7,D0
 BSR COPY

 MOVE.L SPAR+4,-(SP)
 MOVE.W #$20,-(SP)
 TRAP #1
 ADDQ.L #6,SP

 PEA MOUSE+2
 MOVE.W #1,-(SP)
 MOVE.W #25,-(SP)
 TRAP #14
 ADDQ.L #8,SP
 ILLEGAL
COPY:
 MOVE.L (A0)+,(A1)+
 DBRA D0,COPY
 RTS


VBL:
; MOVE.W #$0,$FF8240
 LEA SCREENS,A0
 MOVE.L (A0),D0
 MOVE.L 4(A0),D1
 EXG.L D0,D1
 MOVE.L D0,(A0)
 MOVE.L D1,4(A0)
 MOVE.L D0,A6

 JSR DRAWLAB
 JSR DRAWPAC
 JSR TOPFF
CTRL:        ;PEK!
 JSR CONTROL

 MOVE.B SCREENS+1,$FF8201
 MOVE.B SCREENS+2,$FF8203
 ADDQ.W #1,CLOCK
; MOVE.W #$777,$FF8240
 RTE

TOPFF:
 MOVE.L A6,A1
 LEA TOPGRAF,A0
 MOVE.W #32*20,D0
FF1:
 MOVE.L (A0)+,(A1)
 ADDQ.W #8,A1
 DBRA D0,FF1
 RTS

DRAWPAC:
 LEA PACGRAF,A0
 MOVE.L A6,A1
 ADD.W #(96*160)+8+(16*4),A1
 MOVEQ #0,D4
 MOVE.W #320,D5
 MOVEQ #15,D6
PAC1:
 MOVEM.W (A0)+,D0-D3
 MOVE.L D4,(A1)
 MOVE.W D0,6(A1)
 MOVE.L D4,8(A1)
 MOVE.W D1,14(A1)

 MOVE.L D4,160(A1)
 MOVE.W D2,166(A1)
 MOVE.L D4,168(A1)
 MOVE.W D3,174(A1)
 ADD.W D5,A1
 DBRA D6,PAC1
 RTS

CONTROL:

; CMP.B #$48,$FFFC02
; BEQ UP
; CMP.B #$50,$FFFC02
; BEQ DOWN
; CMP.B #$4D,$FFFC02
; BEQ RIGHT
; CMP.B #$4B,$FFFC02
; BEQ LEFT
; CMP.B #$66,$FFFC02
; BEQ EXIT

 MOVE.B #$16,D1
 LEA $FFFC00,A0
CONT1:
 MOVE.B (A0),D0
 BTST #1,D0
 BEQ CONT1
 MOVE.B D1,2(A0)
 MOVE.B $FFFC02,D0

 BTST #0,D0
 BNE UP
 BTST #1,D0
 BNE DOWN
 BTST #2,D0
 BNE LEFT
 BTST #3,D0
 BNE RIGHT

NOWAY:
 RTS
JOY: DC.B $16,0
UP:
 LEA LABYRINT,A0
 ADD.W PACOORDS,A0
 TST.B -WIDTH(A0)
 BNE NOWAY
 SUB.W #WIDTH,PACOORDS
 MOVE.L #UPPER,CTRL+2
 MOVE.B #9,CCOUNT
 JMP UPPER
DOWN:
 LEA LABYRINT,A0
 ADD.W PACOORDS,A0
 TST.B WIDTH(A0)
 BNE NOWAY
 ADD.W #WIDTH,PACOORDS
 MOVE.L #DOWNER,CTRL+2
 MOVE.B #9,CCOUNT
 JMP DOWNER
RIGHT:
 LEA LABYRINT,A0
 ADD.W PACOORDS,A0
 TST.B 1(A0)
 BNE NOWAY
 ADDQ.W #1,PACOORDS
 MOVE.L #RIGHTER,CTRL+2
 MOVE.L #RIGHTAB,RIGPEK+2
 MOVE.B #9,CCOUNT
 JMP RIGHTER
LEFT:
 LEA LABYRINT,A0
 ADD.W PACOORDS,A0
 TST.B -1(A0)
 BNE NOWAY
 SUBQ.W #1,PACOORDS
 MOVE.L #LEFTER,CTRL+2
 MOVE.L #LEFTAB,LEFPEK+2
 MOVE.B #9,CCOUNT
 JMP LEFTER

NORMER:
 MOVE.L #CONTROL,CTRL+2
 JMP CONTROL
UPPER:
 SUBQ.B #1,CCOUNT
 BEQ NORMER
 SUB.L #(WIDTH*8)*4,DRAWLAB+2
 RTS
DOWNER:
 SUBQ.B #1,CCOUNT
 BEQ NORMER
 ADD.L #(WIDTH*8)*4,DRAWLAB+2
 RTS
RIGHTER:
 SUBQ.B #1,CCOUNT
 BEQ NORMER
RIGPEK:
 MOVE.L RIGHTAB,D0
 ADD.L D0,DRAWLAB+2
 ADDQ.L #4,RIGPEK+2
 RTS
LEFTER:
 SUBQ.B #1,CCOUNT
 BEQ NORMER
LEFPEK:
 MOVE.L LEFTAB,D0
 SUB.L D0,DRAWLAB+2
 ADDQ.L #4,LEFPEK+2
 RTS

RIGHTAB:
 DC.L ADDER,ADDER,ADDER,-((ADDER*3)-4),ADDER,ADDER,ADDER,-((ADDER*3)-4)
LEFTAB:
 DC.L -((ADDER*3)-4),ADDER,ADDER,ADDER,-((ADDER*3)-4),ADDER,ADDER,ADDER
CCOUNT:
 DC.B 0,0

DRAWLAB:
 LEA LABYGRAF,A0
 MOVE.L A6,A1
 ADD.W #(32*160)+8,A1
 MOVE.W #160,D6
 MOVE.W #159,D7

DRAW1:
 MOVE.L A0,A2
 MOVEM.L (A0)+,D0-D5
 MOVE.L D0,(A1)
 MOVE.L D1,8(A1)
 MOVE.L D2,16(A1)
 MOVE.L D3,24(A1)
 MOVE.L D4,32(A1)
 MOVE.L D5,40(A1)
 MOVEM.L (A0)+,D0-D5
 MOVE.L D0,48(A1)
 MOVE.L D1,56(A1)
 MOVE.L D2,64(A1)
 MOVE.L D3,72(A1)
 MOVE.L D4,80(A1)
 MOVE.L D5,88(A1)
 MOVEM.L (A0)+,D0-D5
 MOVE.L D0,96(A1)
 MOVE.L D1,104(A1)
 MOVE.L D2,112(A1)
 MOVE.L D3,120(A1)
 MOVE.L D4,128(A1)
 MOVE.L D5,136(A1)
 ADD.W D6,A1
 LEA 8*WIDTH(A2),A0
 DBRA D7,DRAW1

 RTS

CREATELAB:
 LEA LABYRINT,A0
 LEA LABYGRAF,A2

 MOVEQ #HEIGHT-1,D2
CR3:
 MOVE.L A2,A4
 MOVEQ #WIDTH-1,D1
CR2:
 BSR ONEBLOCK
 ADDQ.W #8,A2
 DBRA D1,CR2
 MOVE.L A4,A2
 ADD.W #(WIDTH*256),A2
 DBRA D2,CR3

 LEA LABYGRAF,A0
 LEA LABYGRAF+ADDER,A1
 MOVE.W #((WIDTH*HEIGHT)*256)/4,D0
 BSR COPY
 LEA LABYGRAF+ADDER,A3
 BSR ROTTER

 LEA LABYGRAF+ADDER,A0
 LEA LABYGRAF+(ADDER*2),A1
 MOVE.W #((WIDTH*HEIGHT)*256)/4,D0
 BSR COPY
 LEA LABYGRAF+(ADDER*2),A3
 BSR ROTTER

 LEA LABYGRAF+(ADDER*2),A0
 LEA LABYGRAF+(ADDER*3),A1
 MOVE.W #((WIDTH*HEIGHT)*256)/4,D0
 BSR COPY
 LEA LABYGRAF+(ADDER*3),A3
 BSR ROTTER

 RTS

ONEBLOCK:
 CLR.W D0
 MOVE.B (A0)+,D0
 LSL.W #8,D0
 LEA LABLOCKS,A1
 ADD.W D0,A1
 MOVE.L A2,A3
 MOVEQ #31,D0
ONEB2:
 MOVE.L (A1)+,(A2)
 MOVE.L (A1)+,4(A2)
 ADD.W #WIDTH*8,A2
 DBRA D0,ONEB2
 MOVE.L A3,A2
 RTS

ROTTER:
 MOVEQ #3,D4
ROT4:
 MOVE.L A3,A0
 MOVE.W #(HEIGHT*32)-1,D1
ROT3:
 MOVE.L A0,A1
 ADD.W #(WIDTH*8)-2,A1
 MOVE #0,CCR
 MOVEQ #(WIDTH*2)-1,D0
ROT1:
 ROXL.W (A1)
 SUBQ.W #4,A1
 DBRA D0,ROT1
 MOVE.L A0,A1
 ADD.W #(WIDTH*8)-4,A1
 MOVEQ #(WIDTH*2)-1,D0
ROT2:
 ROXL.W (A1)
 SUBQ.W #4,A1
 DBRA D0,ROT2
 ADD.W #WIDTH*8,A0
 DBRA D1,ROT3
 DBRA D4,ROT4
 RTS

SPAR: DS.L 10

PAL:
 DC.W $000,$030,$050,$070,$750,$740,$730,$630
 DC.W $770,$771,$770,$760,$750,$740,$730,$630
OPAL:
 DS.W 16,0
OVBL:
 DC.L 0

MOUSE:
 DC.B $12,$14,$14,8

SCREENS:
 DC.L SCR1,SCR

CLOCK:
 DC.W 0

LABYRINT:
 DC.B 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 DC.B 0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0
 DC.B 0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0
 DC.B 0,0,0,1,0,0,2,0,0,0,0,0,1,0,0,0
 DC.B 0,0,0,1,0,0,0,0,1,0,0,0,1,0,0,0
 DC.B 0,0,0,1,0,0,0,0,1,0,0,0,1,0,0,0
 DC.B 0,0,0,1,0,2,0,0,1,0,0,0,1,0,0,0
 DC.B 0,0,0,1,0,2,0,0,0,0,0,0,1,0,0,0
 DC.B 0,0,0,1,0,2,0,0,1,1,1,0,1,0,0,0
 DC.B 0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0
 DC.B 0,0,0,1,0,2,2,0,2,2,2,0,1,0,0,0
 DC.B 0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0
 DC.B 0,0,0,1,0,1,1,1,0,0,0,0,1,0,0,0
 DC.B 0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0
 DC.B 0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0
 DC.B 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

PACOORDS:
 DC.W (WIDTH*2)+4
TOPGRAF:
 IBYTES PACFF.DAT
PACGRAF:
 IBYTES PACMENY.DAT
LABLOCKS:
 IBYTES LABYGRAF.DAT
LABYGRAF:
 END

 